#include <iostream>
#include <cstdlib>
#include <cmath>
#include <vector>
#include <map>
#include <set>
#include <queue>
#include <ctime>
#include <cassert>
#include <string>
#include <cstdlib>
#include <cstring>
#include <algorithm>
#include <memory.h>

using namespace std;

const int N = 2222;
const int INF = 1e9;

vector<int> g[N], e[N];
int n, m, dep[N], pred[N], cost[N], used[N], br[N], go[N], mn1[N], mn2[N], nn1[N];
bool was[N][N];

long long ans;

void dfs(int x) {
	used[x] = true;
	go[x] = dep[x];
	mn1[x] = mn2[x] = INF;
	nn1[x] = -1;
	bool flag = false;
	for (int i = 0; i < g[x].size(); i++) {
		if ((g[x][i] == pred[x]) && (!flag)) {
			flag = true;
			continue;
		}
		if (!used[g[x][i]]) continue;
		go[x] = min(go[x], dep[g[x][i]]);
	}
	mn1[x] = go[x];
	nn1[x] = x;
	for (int i = 0; i < g[x].size(); i++) {
		int y = g[x][i];
		if (used[y]) {
			continue;
		}
		pred[y] = x;
		e[x].push_back(y);
		dep[y] = dep[x] + 1;
		dfs(y);
		if (go[y] <= mn1[x]) {
			mn2[x] = mn1[x];
			mn1[x] = go[y];
			nn1[x] = y;
		} else if (go[y] < mn2[x]) {
			mn2[x] = go[y];
		}
		go[x] = min(go[x], go[y]);
	}
}

void dfs1(int x) {
	for (int i = 0; i < e[x].size(); i++) {
		int y = e[x][i];
		dfs1(y);
		cost[x] += cost[y];
	}
}

void dfs2(int x) {
	for (int j = 0; j < n; j++) was[x][j] = 0;
	for (int i = 0; i < e[x].size(); i++) {
		dfs2(e[x][i]);
		for (int j = 0; j < n; j++) was[x][j] |= was[e[x][i]][j];
	}
	bool flag = false;
	for (int i = 0; i < g[x].size(); i++) {
		if ((g[x][i] == pred[x]) && !flag) {
			flag = true;
			continue;
		}
		if (dep[g[x][i]] > dep[x]) continue;
		was[x][g[x][i]] = true;
	}
	for (int i = 0; i < e[x].size(); i++) {
		int y = e[x][i];
		if (br[y]) continue;
		int cur = INF;
		int px = y;
		for (int e = x; e > 0 && !was[y][e]; e = pred[e]) {
			if (nn1[e] == px) cur = min(cur, mn2[e]);
			else cur = min(cur, mn1[e]);
			px = e;
			if ((cur >= dep[e]) && (!br[e])) {
				ans++;
			}
		}
	}
}

int main() {
	freopen("network.in", "r", stdin);
	scanf("%d%d", &n, &m);
	for (int i = 0; i < m; i++) {
		int x, y;
		scanf("%d%d", &x, &y);
		--x;
		--y;
		if (x == y) continue;
		g[x].push_back(y);
		g[y].push_back(x);
	}
	memset(used, 0, sizeof(used));
	dfs(0);
	pred[0] = -1;
	for (int i = 0; i < n; i++) {
		if (!used[i]) {
			cout << m * 1LL * (m - 1) / 2 << endl;
			return 0;
		}
	}
	for (int x = 0; x < n; x++) {
		for (int i = 0; i < g[x].size(); i++) {
			int y = g[x][i];
			if (dep[y] > dep[x]) {
				cost[y]++;
				cost[x]--;
			}
		}
	}
	dfs1(0);
	int cb = 0, cbb = 0;
	for (int x = 0; x < n; x++) {
		for (int i = 0; i < e[x].size(); i++) {
			int y = e[x][i];
			if (cost[y] == 1) {
				cb++;
				br[y] = true;
			}
			if (cost[y] == 2) {
				cbb++;
			}
		}
	}
	ans = cb * 1LL * (m - cb) + cb * 1LL * (cb - 1) / 2 + cbb;
	memset(used, 0, sizeof(used));
	memset(was, 0, sizeof(was));
//	for (int i = 0; i < n; i++) cerr << i << " " << dep[i] << " " << go[i] << endl;
	for (int i = 0; i < n; i++) {
		for (int j = 0; j < e[i].size(); j++) {
//		 	cerr << i << " " << e[i][j] << endl;
		}
	}
//	cerr << cb << " " << cbb << endl;
	dfs2(0);
	cout << ans << endl;
}
